#!/bin/sh

LOCAL="$1"
REMOTE="$2"

# Sanitize LOCAL path
if [[ ! "$LOCAL" =~ ^/ ]]; then
	LOCAL=$(echo "$LOCAL" | sed -e 's/^\.\///')
	LOCAL="$PWD/$LOCAL"
fi

# Sanitize REMOTE path
if [[ ! "$REMOTE" =~ ^/ ]]; then
	REMOTE=$(echo "$REMOTE" | sed -e 's/^\.\///')
	REMOTE="$PWD/$REMOTE"
fi

MERGING="$4"
BACKUP="/tmp/$(date +"%Y%d%m%H%M%S")"

APPLICATION_PATH="/Applications/Araxis Merge.app"

if [ ! -d "$APPLICATION_PATH" ]; then
	APPLICATION_PATH=/Volumes/$(osascript -e "path to application \"Araxis Merge\" as text" | sed 's/:/\//g')
fi

COMPARE_CMD="$APPLICATION_PATH/Contents/Utilities/compare"

# Looking up the compare command

if [ ! -x "$COMPARE_CMD" ]; then
    APP_PATH=`mdfind kMDItemCFBundleIdentifier="com.araxis.merge"`
    COMPARE_CMD="$APP_PATH/Contents/Utilities/compare"
fi

if [ -n "$MERGING" ]; then
	if [ ! -x "$COMPARE_CMD" ]; then
		echo "Could not find Araxis Merge's araxisgitmerge or compare executable. Please make sure you have installed the command line utils from the Araxis disk image installer." >&2
		exit 128
	fi
	
	BASE="$3"
	MERGE="$4"
	
	# Sanitize BASE path
	if [[ ! "$BASE" =~ ^/ ]]; then
		BASE=$(echo "$BASE" | sed -e 's/^\.\///')
		BASE="$PWD/$BASE"
		
		if [ ! -f "$BASE" ]; then
			BASE=/dev/null
		fi
	fi
	
	# Sanitize MERGE path
	if [[ ! "$MERGE" =~ ^/ ]]; then
		MERGE=$(echo "$MERGE" | sed -e 's/^\.\///')
		MERGE="$PWD/$MERGE"

		if [ ! -f "$MERGE" ]; then
			# For conflict "Both Added", Git does not pass the merge param correctly in current versions
			MERGE=$(echo "$LOCAL" | sed -e 's/\.LOCAL\.[0-9]*//')
		fi
	fi
	
	sleep 1 # required to create different modification timestamp
	touch "$BACKUP"

    "$COMPARE_CMD" -wait "$REMOTE" "$BASE" "$LOCAL" "$MERGE"
else
	if [ ! -x "$COMPARE_CMD" ]; then
		echo "Could not find Araxis Merge's araxisgitdiff or compare executable. Please make sure you have installed the command line utils from the Araxis disk image installer." >&2
		exit 128
	fi

    "$COMPARE_CMD" -wait "$LOCAL" "$REMOTE"
fi

if [ -n "$MERGING" ]; then
	# Check if the merged file has changed
	if [ "$MERGE" -ot "$BACKUP" ]; then
		exit 1
	fi	
fi

exit 0
